IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS]') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS](
	[CD_EMP] [int] NOT NULL,
	[CD_TBL_COMIS_REGRESSAO] [int] NOT NULL,
	[DESC_INI] [money] NOT NULL,
	[DESC_FIM] [money] NOT NULL,
	[PERC_COMIS] [money] NOT NULL,
 CONSTRAINT [PK_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_TBL_COMIS_REGRESSAO] ASC,
	[DESC_INI] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS] ADD  CONSTRAINT [DF_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS] ADD  CONSTRAINT [DF_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS_CD_TBL_COMIS_REGRESSAO]  DEFAULT ((0)) FOR [CD_TBL_COMIS_REGRESSAO]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS] ADD  CONSTRAINT [DF_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS_DESC_INI]  DEFAULT ((0)) FOR [DESC_INI]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS] ADD  CONSTRAINT [DF_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS_DESC_FIM]  DEFAULT ((0)) FOR [DESC_FIM]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS] ADD  CONSTRAINT [DF_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS_PERC_COMIS]  DEFAULT ((0)) FOR [PERC_COMIS]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS_EST_PROD_TBL_COMIS_REGRESSAO] FOREIGN KEY([CD_EMP], [CD_TBL_COMIS_REGRESSAO])
REFERENCES [dbo].[EST_PROD_TBL_COMIS_REGRESSAO] ([CD_EMP], [CD_TBL_COMIS_REGRESSAO])

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS] CHECK CONSTRAINT [FK_EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS_EST_PROD_TBL_COMIS_REGRESSAO]
end